//=============================================================================
// PersonaSkillButtonWindow
//=============================================================================

class BLVendorTile extends PersonaBorderButtonWindow;

#exec TEXTURE IMPORT NAME="BLVendorTile1" FILE="Textures\HatchetInventoryTile1.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="BLVendorTile2" FILE="Textures\HatchetInventoryTile2.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="BLVendorTileSelected1" FILE="Textures\HatchetInventoryTileSelected1.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="BLVendorTileSelected2" FILE="Textures\HatchetInventoryTileSelected2.pcx" GROUP=UI FLAGS=2

var Window                  winIcon;
var PersonaSkillTextWindow  winName, WinDesc;
var Inventory Item;

var Texture Highlight1, Highlight2;
var Texture Def1, Def2;
var int ListNum;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

function SetNum(int i)
{
 ListNum = i;
}

function SetHighlight(bool bHighlight)
{
 if (bHighlight)
 {
  Right_Textures[0].Tex = Highlight2;
  Right_Textures[1].Tex = Highlight2;
  Center_Textures[0].Tex = Highlight1;
  Center_Textures[1].Tex = Highlight1;
 }
 if (!bHighlight)
 {
  Right_Textures[0].Tex = Def2;
  Right_Textures[1].Tex = Def2;
  Center_Textures[0].Tex = Def1;
  Center_Textures[1].Tex = Def1;
 }
}

event InitWindow()
{
	Super.InitWindow();

	SetWidth(264);

	CreateControls();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	winIcon = NewChild(Class'Window');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetPos(3, 3);
	winIcon.SetSize(42, 40);
	
	winName = PersonaSkillTextWindow(NewChild(Class'PersonaSkillTextWindow'));
	winName.SetPos(52, 3);
	winName.SetSize(108, 40);
	winName.SetFont(Font'FontMenuHeaders');

	winDesc = PersonaSkillTextWindow(NewChild(Class'PersonaSkillTextWindow'));
	winDesc.SetPos(160, 3);
	winDesc.SetSize(108, 40);
	winDesc.SetFont(Font'FontMenuHeaders');
}

function UpdateItem()
{
	winIcon.SetSize(GetProperWidth(Item), GetProperHeight(Item));
}

function int GetProperWidth(Inventory I)
{
 local int W;
 
 W = 42;
 if (I.LargeIconWidth < 42 && I.LargeIconWidth > 0) W = I.LargeIconWidth;
 
 return W;
}
function int GetProperHeight(Inventory I)
{
 local int H;
 
 H = 42;
 if (I.LargeIconHeight < 42 && I.LargeIconHeight > 0) H = I.LargeIconHeight;
 
 return H;
}


// ----------------------------------------------------------------------
// SelectButton()
// ----------------------------------------------------------------------

/*function SelectButton(Bool bNewSelected)
{
	bSelected = bNewSelected;

	// Update text colors 
	winName.SetSelected(bSelected);
}*/

// ----------------------------------------------------------------------
// SetButtonMetrics()
//
// Calculates which set of textures we're going to use as well as 
// any text offset (used if the button is pressed in)
// ----------------------------------------------------------------------

/*function SetButtonMetrics()
{
	if (bIsSensitive)
	{
		if (bSelected)				
		{
			textureIndex = 1;
			textColorIndex = 2;
		}
		else
		{
			textureIndex = 0;
			textColorIndex = 0;
		}
	}
	else								// disabled
	{
		textureIndex = 0;
		textColorIndex = 3;
	}
}	*/

// ----------------------------------------------------------------------
// SetSkill()
// ----------------------------------------------------------------------

function SetItem(Inventory newItem)
{
	Item = newItem;

	UpdateItem();
	RefreshItemInfo();
}

// ----------------------------------------------------------------------
// GetSkill()
// ----------------------------------------------------------------------

/*function Skill GetSkill()
{
	return skill;
}*/

// ----------------------------------------------------------------------
// RefreshSkillInfo()
// ----------------------------------------------------------------------

function RefreshItemInfo()
{
	local string S1, S2, S3, S4, S5;

	if (Item != None)
	{
		if (Item.IsA('BorderlandsWeapon'))
		{
		 if (Item.LargeIcon != None) winIcon.SetBackground(Item.LargeIcon);
		 if (Item.LargeIcon == None) winIcon.SetBackground(Item.Icon);

		 winName.SetText(Item.ItemName);
		 if (!Item.Owner.IsA('DeusExPlayer')) winDesc.SetText("Price: $"$BorderlandsWeapon(Item).GetResaleValue() * 5);
		 if (Item.Owner.IsA('DeusExPlayer')) winDesc.SetText("Price: $"$BorderlandsWeapon(Item).GetResaleValue());
		}
	}
}

     /*Left_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Left',Width=4)
     Left_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Left',Width=4)
     Right_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Right',Width=8)
     Right_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Right',Width=8)
     Center_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Center',Width=4)
     Center_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Center',Width=4)*/

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     Left_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_LeftNONNO',Width=0)
     Left_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_LeftNONNO',Width=0)
     Right_Textures(0)=(Tex=Texture'MSBorderlands.UI.BLVendorTile2',Width=8)
     Right_Textures(1)=(Tex=Texture'MSBorderlands.UI.BLVendorTile2',Width=8)
     Center_Textures(0)=(Tex=Texture'MSBorderlands.UI.BLVendorTile1',Width=256)
     Center_Textures(1)=(Tex=Texture'MSBorderlands.UI.BLVendorTile1',Width=256)

     Def1=Texture'MSBorderlands.UI.BLVendorTile1'
     Def2=Texture'MSBorderlands.UI.BLVendorTile2'
     Highlight1=Texture'MSBorderlands.UI.BLVendorTileSelected1'
     Highlight2=Texture'MSBorderlands.UI.BLVendorTileSelected2'

     fontButtonText=Font'DeusExUI.FontMenuTitle'
     buttonHeight=40
     minimumButtonWidth=256
}
